//
//  URLLoader.h
//  Logo
//
//  Created by Jonathan Diehl on 02.03.11.
//  Copyright 2011 RWTH. All rights reserved.
//

#import <Foundation/Foundation.h>

@class URLLoader;
@protocol URLLoaderDelegate
- (void)urlLoader:(URLLoader *)loader didFinishLoadingData:(NSData *)data;
@end


@interface URLLoader : NSObject {
	NSURLRequest *request;
	NSMutableData *data;
	NSURLConnection *connection;
	id <URLLoaderDelegate> delegate;
}

@property(assign) id <URLLoaderDelegate> delegate;

- (id)initWithRequest:(NSURLRequest *)aRequest;
- (void)start;

@end
